/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.impl.variant.shared;

import io.gitlab.jfronny.libjf.mainhttp.api.v0.ServerState;
import io.gitlab.jfronny.libjf.web.impl.host.RequestHandler;
import io.gitlab.jfronny.libjf.web.impl.variant.AbstractWebServer;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class SharedWebServer
extends AbstractWebServer {
    public static final Set<Runnable> onActive = new LinkedHashSet<Runnable>();

    public static void emitActive() {
        Iterator<Runnable> iterator = onActive.iterator();
        while (iterator.hasNext()) {
            Runnable runnable = iterator.next();
            runnable.run();
            iterator.remove();
        }
    }

    public SharedWebServer(RequestHandler handler) {
        super(handler);
    }

    @Override
    public String getServerRoot() {
        if (!ServerState.isActive()) {
            throw new UnsupportedOperationException("Attempted to get server root on unhosted server");
        }
        return this.getServerRoot(ServerState.getPort());
    }

    @Override
    public void stop() {
        throw new UnsupportedOperationException("A shared server cannot be stopped");
    }

    @Override
    public void queueRestart(Runnable callback) {
        onActive.add(() -> {
            this.emitStop();
            this.handler.clear();
            this.performRegistrations();
            this.emitStart();
            callback.run();
        });
        if (this.isActive()) {
            SharedWebServer.emitActive();
        }
    }

    @Override
    public boolean isActive() {
        return ServerState.isActive();
    }
}

